<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'conexion.php';

// Si el formulario fue enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['nombre_dominio']) && !empty($_POST['id_parte'])) {
        $nombre_dominio = trim($_POST['nombre_dominio']);
        $id_parte = intval($_POST['id_parte']);

        $stmt = $conn->prepare("INSERT INTO MUTUAL_DOMINIO (ID_PARTE, NOMBRE_DOMINIO) VALUES (?, ?)");
        if ($stmt) {
            $stmt->bind_param("is", $id_parte, $nombre_dominio);

            if ($stmt->execute()) {
                echo "<p style='color: green;'>✔ Dominio agregado correctamente.</p>";
            } else {
                echo "<p style='color: red;'>❌ Error al ejecutar: " . $stmt->error . "</p>";
            }

            $stmt->close();
        } else {
            echo "<p style='color: red;'>❌ Error al preparar la consulta: " . $conn->error . "</p>";
        }
    } else {
        echo "<p style='color: orange;'>⚠ Todos los campos son obligatorios.</p>";
    }
}

// Obtener las PARTES disponibles desde la base
$partes = $conn->query("SELECT ID_PARTE, NOMBRE_PARTE FROM MUTUAL_PARTE");
?>

<h2>Agregar Dominio</h2>

<form method="POST" action="">

    <label for="id_parte">Parte relacionada:</label><br>
    <select name="id_parte" id="id_parte" required>
        <option value="">-- Selecciona una parte --</option>


 <?php while ($parte = $partes->fetch_assoc()): ?>
    <?php 
        $id = trim($parte['ID_PARTE']);

        // Limpieza completa del nombre
        $nombre = $parte['NOMBRE_PARTE'];
        $nombre = str_replace(["\r", "\n", "\t"], ' ', $nombre); // reemplaza saltos y tabulaciones por espacio
        $nombre = preg_replace('/\s+/', ' ', $nombre);            // convierte múltiples espacios en uno solo
        $nombre = trim($nombre);                                  // quita espacios al inicio y final
    ?>
    <option value="<?= htmlspecialchars($id) ?>">
        <?= htmlspecialchars($nombre) ?>
    </option>
<?php endwhile; ?>

   </select><br><br>


    <label for="nombre_dominio">Nombre del dominio:</label><br>
    <input type="text" id="nombre_dominio" name="nombre_dominio" required><br><br>


    <input type="submit" value="Guardar Dominio">
</form>
