<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$usuario_actual = $_SESSION['usuario'];
$id_usuario = $_SESSION['id_usuario'];

$dsn = "mysql:host=localhost;dbname=cpl110345_planos;charset=utf8mb4";
try {
    $conn = new PDO($dsn, "cpl110345_planosusr", "planos#####PLANOS", [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

$stmt = $conn->prepare("SELECT ID_TRABAJADOR, NOMBRE_APELLIDO FROM MUTUAL_TRABAJADORES WHERE ID_USUARIO = ?");
$stmt->execute([$id_usuario]);
$trabajadores = $stmt->fetchAll(PDO::FETCH_ASSOC);

$fecha_actual = date("Y-m-d");
$hora_actual = date("H:i");

setlocale(LC_TIME, 'es_ES.UTF-8');
$fecha_mostrar = strftime('%A %d de %B %Y', strtotime($fecha_actual));
$fecha_mostrar = ucfirst($fecha_mostrar);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Charla Diaria</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/mutual_icono_vineta.png" type="image/x-icon">
    <style>
        body {
            margin: 0;
            padding-top: 80px;
            font-family: 'Helvetica', sans-serif;
        }

        .contenedor-principal {
            max-width: 600px;
            margin: 0 auto;
            position: relative;
        }

        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            z-index: 999;
            display: flex;
            justify-content: center; 
            align-items: center;
            padding: 0;
            box-sizing: border-box;
        }

        .contenido-titulo {
            max-width: 800px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 10px;
            box-sizing: border-box;
        }

        .titulo-izq, .titulo-der {
            flex: 0 0 auto;
            padding: 0 10px;
        }

        .titulo-centro {
            flex: 1;
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            font-family: 'Helvetica', sans-serif;
        }

        form {
            background: rgba(255, 255, 255, 0.95);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            max-width: 800px;
        }

        input[type="text"],
        input[type="file"],
        textarea {
            width: 100%;
            padding: 8px;
            margin: 5px 0 10px;
            border-radius: 4px;
            border: 1px solid #ccc;
            box-sizing: border-box;
            font-size: 16px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid #ccc;
            padding: 6px;
            text-align: center;
            font-size: 16px;
        }

        th {
            background-color: #004080;
            color: white;
        }

        .subtitulo {
            font-size: 20px;
            font-weight: bold;
            margin: 10px 0 10px;
            color: #003366;
        }

        .fecha-hora-centrado {
            display: flex;
            justify-content: center;
            gap: 60px;
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            margin: 5px 0 5px;
        }

        .custom-file-upload {
            display: inline-flex;
            align-items: center;
            padding: 10px 16px;
            background-color: #007BFF;
            color: white;
            font-weight: bold;
            border-radius: 6px;
            cursor: pointer;
            gap: 10px;
            font-family: 'Helvetica', sans-serif;
            margin-bottom: 8px;
        }

        .custom-file-upload img {
            height: 20px;
            width: 20px;
        }

        .custom-file-upload input[type="file"] {
            display: none;
        }

        .nombre-archivo {
            display: block;
            margin-top: 4px;
            font-size: 16px;
            color: #eb3f24;
            font-style: italic;
        }
        
        
        .archivo-seleccionado {
            display: block;
            margin-top: 4px;
            font-size: 16px;
            color: #00b041;
            font-style: italic;

        }

        footer {
            text-align: center;
            margin-top: 40px;
            font-size: 0.9em;
            color: #666;
        }

        h3 {
            color: #003366;
            font-size: 20px;
            font-weight: bold;
            font-family: 'Helvetica', sans-serif;
            margin-top: 20px;
            margin-bottom: 8px;
        }
        
        
        .botones .grabarf {
        background:#358b26 ;
        padding: 12px 24px;
        font-size: 15px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
    }

    .botones .grabarf:hover {
        background:#1e4c15 ;
    }
        
    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="contenido-titulo">
        <div class="titulo-izq">
            <img src="iconos/mutual_icono_diaria.png" alt="Evaluar" style="width: 60px; height: 60px;">
        </div>
        <div class="titulo-centro">Registrar Reunión de Inicio Turno</div>
        <div class="titulo-der">
            <a href="mutual_menuppl.php" title="Volver">
                <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
            </a>
        </div>
    </div>
</div>

<form action="mutual_guardar_evaluacion_diaria.php" method="POST" enctype="multipart/form-data" onsubmit="return validarFoto()">
    <input type="hidden" name="id_usuario" value="<?= htmlspecialchars($id_usuario) ?>">
    <input type="hidden" name="fecha" value="<?= $fecha_actual ?>">
    <input type="hidden" name="hora" value="<?= $hora_actual ?>">
    <input type="hidden" name="total_trabajadores" value="<?= count($trabajadores) ?>">

    <div class="fecha-hora-centrado">
        <span> <?= $fecha_mostrar ?></span>
        <span> <?= $hora_actual ?></span>
    </div>

    <h3>Foto de pizarra (obligatoria *)</h3>
    <label class="custom-file-upload">
        <img src="iconos/mutual_icono_camara.png" alt="Ícono Foto" style="width: 40px; height: 40px;">
        Tomar Fotografía / Archivo 
        <input type="file" name="foto_pizarra" id="foto_pizarra" accept="image/*" capture="environment">
    </label>
    <span id="nombre_foto_pizarra" class="nombre-archivo">Ningún archivo seleccionado</span>


    <h3>Foto adicional (opcional)</h3>
    <label class="custom-file-upload">
        <img src="iconos/mutual_icono_camara.png" alt="Ícono Foto" style="width: 40px; height: 40px;">
        Tomar Fotografía / Archivo
        <input type="file" name="foto_adicional" id="foto_adicional" accept="image/*" capture="environment">
    </label>
    <span id="nombre_foto_adicional" class="nombre-archivo">Ningún archivo seleccionado</span>

    <div class="subtitulo">Lista de Trabajadores</div>
    <table>
        <tr>
            <th style="width: 20%;">Asistencia</th>
            <th style="width: 20%;">Fuera de hora</th>
            <th style="width: 60%;">Nombre Apellido</th>
        </tr>
        <?php foreach ($trabajadores as $trab): $id = $trab['ID_TRABAJADOR']; ?>
            <tr>

                <td><input type="checkbox" id="asiste_<?= $id ?>" name="asistencia[<?= $id ?>]" value="1" checked onchange="toggleEnHora(<?= $id ?>); contarAsistentes();"></td>
                <td><input type="checkbox" id="enhora_<?= $id ?>" name="en_hora[<?= $id ?>]" value="1"></td>
                
                <td style="text-align: left; padding-left: 10px;"><?= htmlspecialchars($trab['NOMBRE_APELLIDO']) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <div class="contador" style="margin-top: 20px;">
        Total Asistentes: <span id="contador_asistentes">0</span> / <?= count($trabajadores) ?>
    </div>

    <div class="subtitulo">Observaciones generales:</div>
    <textarea name="observaciones" rows="3" placeholder="Escriba observaciones generales..."></textarea><br>

    <div class="botones">
        <button type="submit" class="grabarf">
            <img src="iconos/mutual_icono_grabar.png" alt="Guardar" style="height:60px; vertical-align:middle; margin-right:8px;">
            Guardar Reunión Diaria
        </button>
    </div>
    
    
</form>

<script>
function toggleEnHora(id) {
    const checkAsiste = document.getElementById('asiste_' + id);
    const checkHora = document.getElementById('enhora_' + id);
    checkHora.disabled = !checkAsiste.checked;
    if (!checkAsiste.checked) {
        checkHora.checked = false;
    }
}

function contarAsistentes() {
    const checkboxes = document.querySelectorAll('input[name^="asistencia"]:checked');
    document.getElementById('contador_asistentes').innerText = checkboxes.length;
}

function validarFoto() {
    const archivo = document.getElementById('foto_pizarra');
    if (!archivo.files || archivo.files.length === 0) {
        alert("Debe seleccionar una foto de pizarra.");
        return false;
    }
    return true;
}




document.getElementById('foto_pizarra').addEventListener('change', function () {
    const input = this;
    const nombreElemento = document.getElementById('nombre_foto_pizarra');

    if (input.files.length > 0) {
        const nombreArchivo = input.files[0].name;
        nombreElemento.textContent = `Archivo cargado ✅: ${nombreArchivo}`;
        nombreElemento.classList.add('archivo-seleccionado');
    } else {
        nombreElemento.textContent = 'Ningún archivo seleccionado';
        nombreElemento.classList.remove('archivo-seleccionado');
    }
});





document.getElementById('foto_adicional').addEventListener('change', function () {
    const archivoInput = this;
    const nombreElemento = document.getElementById('nombre_foto_adicional');

    if (archivoInput.files.length > 0) {
        const nombreArchivo = archivoInput.files[0].name;
        nombreElemento.textContent = `Archivo cargado ✅: ${nombreArchivo}`;
        nombreElemento.classList.add('archivo-seleccionado');
    } else {
        nombreElemento.textContent = 'Ningún archivo seleccionado';
        nombreElemento.classList.remove('archivo-seleccionado');
    }
});



</script>

</body>
</html>
