<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];
$id_usuario_sesion = $_SESSION['id_usuario'];

error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'mutual_conexion.php';

// Obtener usuarios

$stmt = $conn->prepare("
    SELECT ID_USUARIO, NOMBRE_APELLIDO
    FROM MUTUAL_USUARIOS
    WHERE ID_USUARIO_MOV = ?
    ORDER BY NOMBRE_APELLIDO ASC
");
$stmt->bind_param("i", $id_usuario_sesion);
$stmt->execute();
$usuarios = $stmt->get_result();



// Obtener partes y dominios agrupados
$partes_q = $conn->query("SELECT * FROM MUTUAL_PARTE");
$partes = [];
while ($p = $partes_q->fetch_assoc()) {
    $id_parte = $p['ID_PARTE'];
    $partes[$id_parte] = [
        'nombre' => $p['NOMBRE_PARTE'],
        'dominios' => []
    ];
}

$dominios_q = $conn->query("SELECT ID_DOMINIO, ID_PARTE, NOMBRE_DOMINIO FROM MUTUAL_DOMINIO");
while ($d = $dominios_q->fetch_assoc()) {
    $partes[$d['ID_PARTE']]['dominios'][] = $d;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Evaluación</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/mutual_icono_vineta.png" type="image/x-icon">
        <meta name="viewport" content="width=device-width, initial-scale=1">

 <!--    <meta name="viewport" content="width=device-width, initial-scale=1">  -->


<style>
    form {
        max-width: 800px;
        margin: 100px auto 20px;
        padding: 20px;
        background: rgba(255, 255, 255, 0.95);
        border-radius: 10px;
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        font-family: 'Helvetica', sans-serif;
    }

    .bloque-subida {
        border: 1px solid #ccc;
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 6px;
        background: #fafafa;
    }

    legend {
        font-weight: bold;
        color: #003366;
    }

    input[type="text"],
    select,
    textarea {
        width: 100%;
        padding: 8px;
        margin: 5px 0 10px;
        border-radius: 4px;
        border: 1px solid #ccc;
        box-sizing: border-box;
        font-family: 'Helvetica', sans-serif;
    }

    .nota-parte-display {
        width: 60px;
    }

    .botones {
        text-align: center;
        margin-top: 30px;
    }
    
    


    .botones .grabarf {
        background:#267802 ;
        padding: 12px 24px;
        font-size: 15px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
    }

    .botones .grabarf:hover {
        background:#0c660a ;
    }

    .dominio-label {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 10px;
        cursor: pointer;
        width: 100%;
    }

    .dominio-label span {
        flex: 1;
        font-size: 15px;
        line-height: 1.4;
        white-space: normal;
        word-break: break-word;
        overflow-wrap: break-word;
    }

.titulo-evaluacion-fijo {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  height: 70px;
  background: rgba(255,255,255,0.95);
  box-shadow: 0 6px 12px rgba(0,0,0,0.15);
  z-index: 999;
  display: flex;
  justify-content: center; /* para centrar el contenido interno */
  align-items: center;
  padding: 0;
  box-sizing: border-box;
}

.contenido-titulo {
  max-width: 800px; /* mismo ancho que el formulario */
  width: 100%;
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 0 10px; /* opcional, para un poco de espacio interno */
  box-sizing: border-box;
}


 .titulo-izq, .titulo-der {
  flex: 0 0 auto;
  padding: 0 10px;
}

.titulo-centro {
  flex: 1;
  text-align: center;
  font-size: 20px;
  font-weight: bold;
  color: #003366;
  font-family: 'Helvetica', sans-serif;
}


.nota-roja {
    color: #c00000;
    font-weight: bold;
}

.nota-amarilla {
    color: #FF8000;
    font-weight: bold;
}

.nota-verde {
    color: #007a2f;
    font-weight: bold;
}

</style>
</head>
<body>





<div class="titulo-evaluacion-fijo">
  <div class="contenido-titulo">
    <div class="titulo-izq">
        <img src="iconos/mutual_icono_evalua.png" alt="Evaluar" style="width: 60px; height: 60px;">
    </div>
    <div class="titulo-centro">Evalaución Supervisor</div>
    <div class="titulo-der">
        <a href="mutual_menuppl.php" title="Volver">
            <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
      </a>
    </div>
  </div>
</div>


<form method="POST" action="mutual_guardar_evaluacion_full.php">
    <label for="id_usuario"><strong>Usuario:</strong></label><br>
    <select name="id_usuario" id="id_usuario" class="centrar-select" required>
        <option value="">-- Selecciona supervisor --</option>
        <?php while ($u = $usuarios->fetch_assoc()): ?>
            <option value="<?= $u['ID_USUARIO'] ?>"><?= htmlspecialchars($u['NOMBRE_APELLIDO']) ?></option>
        <?php endwhile; ?>
    </select><br><br>

    <?php foreach ($partes as $id_parte => $parte): ?>
        <fieldset class="bloque-subida">
            <legend><strong><?= htmlspecialchars($parte['nombre']) ?></strong></legend>

            <div id="parte_<?= $id_parte ?>">
                <?php foreach ($parte['dominios'] as $dominio):
                    $checkbox_id = "dom_{$id_parte}_{$dominio['ID_DOMINIO']}";
                ?>
                <label class="dominio-label" for="<?= $checkbox_id ?>">
                    <input type="checkbox"
                           id="<?= $checkbox_id ?>"
                           class="dominio-checkbox parte-<?= $id_parte ?>"
                           data-parte="<?= $id_parte ?>"
                           data-dominio="<?= $dominio['ID_DOMINIO'] ?>"
                           name="dominios[<?= $id_parte ?>][<?= $dominio['ID_DOMINIO'] ?>]"
                           value="1">
                    <span><?= htmlspecialchars($dominio['NOMBRE_DOMINIO']) ?></span>
                </label>
                <?php endforeach; ?>
            </div>

            <label><strong>Nota total de esta parte:</strong></label><br>
            <input type="text"
                   id="nota_parte_<?= $id_parte ?>"
                   class="nota-parte-display"
                   value="0"
                   readonly
                   style="width: 60px;"><br>

            <input type="hidden" name="nota_parte[<?= $id_parte ?>]" id="nota_parte_input_<?= $id_parte ?>" value="0">

            <label><strong>Observaciones:</strong></label><br>
            <textarea name="observaciones[<?= $id_parte ?>]"
                      rows="3"
                      cols="60"
                      placeholder="Escribe observaciones aquí..."></textarea><br>
        </fieldset>
    <?php endforeach; ?>

    <!-- Campo puntos a destacar, mejorar y accidentes -->
    <fieldset class="bloque-subida">
        <legend><strong>Comentarios Generales</strong></legend>

        <label for="puntos_destacar"><strong>Puntos a Destacar:</strong></label><br>
        <textarea name="puntos_destacar" id="puntos_destacar" rows="3" maxlength="500" placeholder="Fortalezas observadas..."></textarea><br>

        <label for="puntos_mejorar"><strong>Puntos a Mejorar:</strong></label><br>
        <textarea name="puntos_mejorar" id="puntos_mejorar" rows="3" maxlength="500" placeholder="Aspectos a mejorar..."></textarea><br>



<label for="accidentes"><strong>Cantidad de Accidentes:</strong></label><br>
<input type="number"
       name="accidentes"
       id="accidentes"
       min="0"
       max="9"
       step="1"
       style="width: 40px; text-align: center;"
       placeholder="0"
       oninput="this.value = this.value.replace(/[^0-9]/g,'').slice(0,1);"><br>




    </fieldset>
    
    

<div class="botones">
    <!-- Resumen dinámico de notas -->
    <div id="resumen_notas" style="margin-bottom: 15px; text-align: left; background: #f5f5f5; padding: 10px; border-radius: 6px;">
        <strong>Resumen de notas:</strong>
        <ul id="resumen_list" style="margin-top: 5px; padding-left: 20px;">
            <?php foreach ($partes as $id_parte => $parte): ?>
                <li><?= htmlspecialchars($parte['nombre']) ?>: <span id="nota_bloque_<?= $id_parte ?>">0.0</span></li>
            <?php endforeach; ?>
        </ul>
        <p>Promedio actual: <strong id="promedio_display">0.0</strong></p>
    </div>

    <button type="submit" class="grabarf">
        <img src="iconos/mutual_icono_grabar.png" alt="Guardar" style="height:60px; vertical-align:middle; margin-right:8px;">
        Grabar Evaluación
    </button>
</div>






</form>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>



<script>

<?= file_get_contents('mutual_scripts_evaluacion_por_parte.js'); ?>

function actualizarResumen() {
    const totalBloques = <?= count($partes) ?>;
    let sumaNotas = 0;

    <?php foreach ($partes as $id_parte => $parte): ?>
        let nota<?= $id_parte ?> = parseFloat(
            document.getElementById('nota_parte_input_<?= $id_parte ?>').value
        ) || 0;

        let span<?= $id_parte ?> = document.getElementById('nota_bloque_<?= $id_parte ?>');
        span<?= $id_parte ?>.innerText = nota<?= $id_parte ?>.toFixed(1);

        span<?= $id_parte ?>.className = '';
        if (nota<?= $id_parte ?> < 4) {
            span<?= $id_parte ?>.classList.add('nota-roja');
        } else if (nota<?= $id_parte ?> < 6) {
            span<?= $id_parte ?>.classList.add('nota-amarilla');
        } else {
            span<?= $id_parte ?>.classList.add('nota-verde');
        }

        sumaNotas += nota<?= $id_parte ?>;
    <?php endforeach; ?>

    let promedio = sumaNotas / totalBloques;
    promedio = Math.round(promedio * 10) / 10;

    let promedioSpan = document.getElementById('promedio_display');
    promedioSpan.innerText = promedio.toFixed(1);
    promedioSpan.className = '';

    if (promedio < 4) {
        promedioSpan.classList.add('nota-roja');
    } else if (promedio < 6) {
        promedioSpan.classList.add('nota-amarilla');
    } else {
        promedioSpan.classList.add('nota-verde');
    }
}

// Escuchar cambios
document.querySelectorAll('.dominio-checkbox').forEach(cb => {
    cb.addEventListener('change', function() {
        if (typeof calcularNotasPorParte === 'function') {
            calcularNotasPorParte();
        }
        actualizarResumen();
    });
});

window.addEventListener('DOMContentLoaded', actualizarResumen);

<?= file_get_contents('mutual_scripts_evaluacion_por_parte.js'); ?>

</script>



</body>
</html>
