<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$usuario_actual = $_SESSION['usuario'];
$id_usuario = $_SESSION['id_usuario'];

include 'mutual_conexion.php';

$stmt = $conn->prepare("
   SELECT 
        E.ID_EVALUACION_DIARIA, 
        E.FECHA, 
        E.HORA, 
        E.FOTO_PIZARRA, 
        E.FOTO_ADICIONAL, 
        E.OBSERVACIONES,
        E.TOTAL_ASISTENTES,
        E.TOTAL_TRABAJADORES,
        U.NOMBRE_APELLIDO AS SUPERVISOR
    FROM MUTUAL_EVALUACION_DIARIA E
    LEFT JOIN MUTUAL_USUARIOS U ON E.ID_USUARIO = U.ID_USUARIO
    ORDER BY E.ID_EVALUACION_DIARIA DESC
");

$stmt->execute();
$evaluaciones = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Lista Evaluaciones Diarias</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/01_mutual_icono_vineta.png" type="image/x-icon">
    <style>
        table {
            width: 95%;
            margin: 100px auto 20px;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }
        table th, table td {
            padding: 10px;
            text-align: center;
            font-size: 13px;
        }
        table td.obs {
            text-align: left;
        }
        table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }
        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            width: auto;
            cursor: pointer;
        }
        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            text-align: center;
            flex-grow: 1;
        }
        a.foto-link {
            color: #007bff;
            text-decoration: none;
        }
        a.foto-link:hover {
            text-decoration: underline;
        }
        .boton-ver {
            padding: 6px 14px;
            font-size: 13px;
            border: none;
            background-color: #0c4896;
            color: white;
            border-radius: 6px;
            cursor: pointer;
        }
        .boton-ver:hover {
            background-color: #06306e;
        }
    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/mutual_icono_diaria.png" alt="Evaluar" style="width: 60px; height: auto;">
    </div>
    <div class="titulo-centro">Lista Evaluaciones Diarias</div>
    <div class="titulo-der">
        <a href="mutual_menuppl.php" title="Volver">
            <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
        </a>
    </div>
</div>

<table>


<thead>
    <tr>
        <th style="width: 5%;">Folio</th>
        <th style="width: 15%;">Supervisor</th>
        <th style="width: 10%;">Fecha</th>
        <th style="width: 10%;">Hora</th>
        <th style="width: 15%;">Observaciones</th>
        <th style="width: 5%;">Asistentes</th>
        <th style="width: 5%;">Trabajadores</th>
        <th style="width: 10%;">Foto Pizarra</th>
        <th style="width: 10%;">Foto Adicional</th>
        <th style="width: 10%;">Ver Detalle</th>
    </tr>
</thead>



    <tbody>
        <?php while ($row = $evaluaciones->fetch_assoc()): ?>
            <tr>
                <td><?= $row['ID_EVALUACION_DIARIA'] ?></td>
                <td><?= htmlspecialchars($row['SUPERVISOR']) ?></td>
                <td><?= $row['FECHA'] ?></td>
                <td><?= $row['HORA'] ?></td>
                <td class="obs"><?= htmlspecialchars($row['OBSERVACIONES']) ?></td>
                <td><?= intval($row['TOTAL_ASISTENTES']) ?></td>
                <td><?= intval($row['TOTAL_TRABAJADORES']) ?></td>
                <td>
                    <?php if (!empty($row['FOTO_PIZARRA'])): ?>
                        <a class="foto-link" href="Foto_diaria/<?= urlencode($row['FOTO_PIZARRA']) ?>" target="_blank">
                            <?= htmlspecialchars($row['FOTO_PIZARRA']) ?>
                        </a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td>
                    <?php if (!empty($row['FOTO_ADICIONAL'])): ?>
                        <a class="foto-link" href="Foto_diaria/<?= urlencode($row['FOTO_ADICIONAL']) ?>" target="_blank">
                            <?= htmlspecialchars($row['FOTO_ADICIONAL']) ?>
                        </a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td>
                    <a href="mutual_ver_evaluacion_diaria_todas.php?id_evaluacion=<?= $row['ID_EVALUACION_DIARIA'] ?>">

                        <button class="boton-ver">Ver Detalle</button>
                    </a>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

</body>
</html>
