// --- PARTE 1 ---
document.querySelectorAll('.parte-1').forEach(chk => {
    chk.addEventListener('change', function() {
        const checkbox15 = document.querySelector('.parte-1[data-dominio="15"]');
        const checkbox16 = document.querySelector('.parte-1[data-dominio="16"]');
        let nota = 0;

        if (checkbox15.checked && checkbox16.checked) {
            nota = 7;
        } else if (checkbox15.checked) {
            nota = 4;
        } else if (checkbox16.checked) {
            nota = 3;
        } else {
            nota = 0;
        }

        document.getElementById('nota_parte_1').value = nota;
        document.getElementById('nota_parte_input_1').value = nota;
    });
});

// --- PARTE 2 ---
document.querySelectorAll('.parte-2').forEach(chk => {
    chk.addEventListener('change', function () {

        const valores = {
            17: 1.5, // check 1
            18: 1.5, // check 2
            19: 1,   // check 3
            20: 1,   // check 4
            21: 1,   // check 5
            22: 1    // check 6
        };

        const checked = Array.from(document.querySelectorAll('.parte-2:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;

        checked.forEach(id => {
            if (valores[id]) {
                nota += valores[id];
            }
        });

        document.getElementById('nota_parte_2').value = nota;
        document.getElementById('nota_parte_input_2').value = nota;
    });
});


// --- PARTE 3 ---
document.querySelectorAll('.parte-3').forEach(chk => {
    chk.addEventListener('change', function () {

        const valores = {
            23: 1.5, // check 1
            24: 2,   // check 2
            25: 1.5, // check 3
            26: 2    // check 4
        };

        const checked = Array.from(document.querySelectorAll('.parte-3:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;

        checked.forEach(id => {
            if (valores[id]) {
                nota += valores[id];
            }
        });

        document.getElementById('nota_parte_3').value = nota;
        document.getElementById('nota_parte_input_3').value = nota;
    });
});

// --- PARTE 4 ---
document.querySelectorAll('.parte-4').forEach(chk => {
    chk.addEventListener('change', function () {

        const valores = {
            27: 2, // check 1
            28: 2, // check 2
            29: 2, // check 3
            30: 1  // check 4
        };

        const checked = Array.from(document.querySelectorAll('.parte-4:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;

        checked.forEach(id => {
            if (valores[id]) {
                nota += valores[id];
            }
        });

        document.getElementById('nota_parte_4').value = nota;
        document.getElementById('nota_parte_input_4').value = nota;
    });
});


// --- PARTE 5 ---
document.querySelectorAll('.parte-5').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);

        // Exclusión: solo uno entre 32, 33 y 34
        if ([32, 33, 34].includes(id) && this.checked) {
            document.querySelectorAll('.parte-5').forEach(cb => {
                const cbId = parseInt(cb.dataset.dominio);
                if (cbId !== id && [32, 33, 34].includes(cbId)) {
                    cb.checked = false;
                }
            });
        }

        let nota = 0;

        // Check 1
        if (document.querySelector('.parte-5[data-dominio="31"]').checked) {
            nota += 3;
        }

        // Checks 2–3–4 (solo uno)
        if (document.querySelector('.parte-5[data-dominio="32"]').checked) {
            nota += 4;
        } else if (document.querySelector('.parte-5[data-dominio="33"]').checked) {
            nota += 3;
        } else if (document.querySelector('.parte-5[data-dominio="34"]').checked) {
            nota += 0;
        }

        document.getElementById('nota_parte_5').value = nota;
        document.getElementById('nota_parte_input_5').value = nota;
    });
});


// --- PARTE 6 ---
document.querySelectorAll('.parte-6').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);

        // Exclusión estricta: solo uno entre 35, 36 y 37
        if (this.checked && [35, 36, 37].includes(id)) {
            document.querySelectorAll('.parte-6').forEach(cb => {
                if (parseInt(cb.dataset.dominio) !== id) {
                    cb.checked = false;
                }
            });
        }

        let nota = 0;

        if (document.querySelector('.parte-6[data-dominio="35"]').checked) {
            nota = 7;
        } else if (document.querySelector('.parte-6[data-dominio="36"]').checked) {
            nota = 5.5;
        } else if (document.querySelector('.parte-6[data-dominio="37"]').checked) {
            nota = 4;
        }

        document.getElementById('nota_parte_6').value = nota;
        document.getElementById('nota_parte_input_6').value = nota;
    });
});



// --- PARTE 7 ---
document.querySelectorAll('.parte-7').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);

        // Exclusión estricta entre 38, 39 y 40
        if (this.checked && [38, 39, 40].includes(id)) {
            document.querySelectorAll('.parte-7').forEach(cb => {
                const cbId = parseInt(cb.dataset.dominio);
                if (cbId !== id && [38, 39, 40].includes(cbId)) {
                    cb.checked = false;
                }
            });
        }

        let nota = 0;

        // Grupo exclusivo
        if (document.querySelector('.parte-7[data-dominio="38"]').checked) {
            nota += 3;
        } else if (document.querySelector('.parte-7[data-dominio="39"]').checked) {
            nota += 2;
        } else if (document.querySelector('.parte-7[data-dominio="40"]').checked) {
            nota += 1;
        }

        // Grupo no exclusivo
        if (document.querySelector('.parte-7[data-dominio="41"]').checked) nota += 1;
        if (document.querySelector('.parte-7[data-dominio="42"]').checked) nota += 1;
        if (document.querySelector('.parte-7[data-dominio="43"]').checked) nota += 2;

        document.getElementById('nota_parte_7').value = nota;
        document.getElementById('nota_parte_input_7').value = nota;
    });
});
