<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$usuario_actual = $_SESSION['usuario'];
$id_usuario = $_SESSION['id_usuario'];

$dsn = "mysql:host=localhost;dbname=cpl110345_planos;charset=utf8mb4";
try {
    $conn = new PDO($dsn, "cpl110345_planosusr", "planos#####PLANOS", [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("Error de conexin: " . $e->getMessage());
}

$stmt = $conn->prepare("SELECT ID_TRABAJADOR, NOMBRE_APELLIDO FROM MUTUAL_TRABAJADORES WHERE ID_USUARIO = ?");
$stmt->execute([$id_usuario]);
$trabajadores = $stmt->fetchAll(PDO::FETCH_ASSOC);

$fecha_actual = date("Y-m-d");
$hora_actual = date("H:i");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Evaluacin Diaria</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/01_mutual_icono_vineta.png" type="image/x-icon">

    <style>
        form {
            max-width: 850px;
            margin: 100px auto 20px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }

        input[type="text"],
        input[type="file"],
        textarea {
            width: 100%;
            padding: 8px;
            margin: 5px 0 10px;
            border-radius: 4px;
            border: 1px solid #ccc;
            box-sizing: border-box;
            font-family: 'Helvetica', sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #ccc;
            padding: 6px;
            text-align: center;
        }

        th {
            background-color: #eee;
        }

        .botones {
            text-align: center;
            margin-top: 30px;
        }

        .grabar {
            background: #04bf65;
            color: white;
            padding: 12px 24px;
            font-size: 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }

        .grabar:hover {
            background: #036335;
        }

        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }

        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            cursor: pointer;
        }

        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            flex-grow: 1;
            text-align: center;
        }

        .contador {
            margin-top: 10px;
            font-weight: bold;
        }

        footer {
            text-align: center;
            margin-top: 40px;
            font-size: 0.9em;
            color: #666;
        }
    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/13_mutual_icono_evaluar.png" alt="Evaluar" style="width: 60px; height: 60px;">
    </div>
    <div class="titulo-centro">Registrar Evaluacin Diaria</div>
    <div class="titulo-der">
        <a href="mutual_menueval.php" title="Volver">
            <img src="iconos/08_mutual_icono_volver.png" alt="Volver" style="width: 60px; height: 60px;">
        </a>
    </div>
</div>

<form action="mutual_guardar_evaluacion_diaria.php" method="POST" enctype="multipart/form-data" onsubmit="return validarFoto()">
    <input type="hidden" name="id_usuario" value="<?= htmlspecialchars($id_usuario) ?>">
    <input type="hidden" name="fecha" value="<?= $fecha_actual ?>">
    <input type="hidden" name="hora" value="<?= $hora_actual ?>">

    <p><strong>Fecha:</strong> <?= $fecha_actual ?></p>
    <p><strong>Hora:</strong> <?= $hora_actual ?></p>

    <label><strong>Observaciones generales:</strong></label><br>
    <textarea name="observaciones" rows="3" placeholder="Escriba observaciones generales..."></textarea><br>

    <label><strong>Foto de pizarra (obligatoria):</strong></label><br>
    <input type="file" name="foto_pizarra" id="foto_pizarra" accept="image/*" capture="environment" required><br>

    <label><strong>Foto adicional (opcional):</strong></label><br>
    <input type="file" name="foto_adicional" accept="image/*" capture="environment"><br>

    <h3>Lista de Trabajadores</h3>
    <table>
        <tr>
            <th>Asistencia</th>
            <th>Nombre</th>
            <th>Lleg a la hora</th>
        </tr>
        <?php foreach ($trabajadores as $trab): 
            $id = $trab['ID_TRABAJADOR'];
        ?>
        <tr>
            <td>
                <input type="checkbox" id="asiste_<?= $id ?>" name="trabajadores[]" value="<?= $id ?>" onchange="toggleEnHora(<?= $id ?>); contarAsistentes();">
            </td>
            <td><?= htmlspecialchars($trab['NOMBRE_APELLIDO']) ?></td>
            <td>
                <input type="checkbox" id="enhora_<?= $id ?>" name="en_hora[<?= $id ?>]" value="1" disabled>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>

    <div class="contador">
        Total Asistentes: <span id="contador_asistentes">0</span> / <?= count($trabajadores) ?>
    </div>

    <div class="botones">
        <button type="submit" class="grabar">
            <img src="iconos/14_mutual_icono_grabar.png" alt="Guardar" style="height:40px; vertical-align:middle; margin-right:8px;">
            Guardar Evaluacin
        </button>
    </div>
</form>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

<script>
function toggleEnHora(id) {
    const checkAsiste = document.getElementById('asiste_' + id);
    const checkHora = document.getElementById('enhora_' + id);
    checkHora.disabled = !checkAsiste.checked;
    if (!checkAsiste.checked) {
        checkHora.checked = false;
    }
}

function contarAsistentes() {
    const checkboxes = document.querySelectorAll('input[name="trabajadores[]"]:checked');
    document.getElementById('contador_asistentes').innerText = checkboxes.length;
}

function validarFoto() {
    const archivo = document.getElementById('foto_pizarra');
    if (!archivo.value) {
        alert("Debe seleccionar una foto de pizarra.");
        return false;
    }
    return true;
}
</script>

</body>
</html>
