<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];

error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'mutual_conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_usuario = intval($_POST['id_usuario']);
    $dominios_por_parte = $_POST['dominios'] ?? [];
    $notas_parte = $_POST['nota_parte'] ?? [];
    $observaciones = $_POST['observaciones'] ?? [];

    // NUEVOS CAMPOS
    $puntos_destacar = trim($_POST['puntos_destacar'] ?? '');
    $puntos_mejorar  = trim($_POST['puntos_mejorar'] ?? '');
    
    // ACCIDENTES: se asegura que sea un entero entre 0 y 9
    $accidentes = isset($_POST['accidentes']) ? min(max(intval($_POST['accidentes']), 0), 9) : 0;

    $conn->begin_transaction();

    try {
        // Insertar evaluación con nuevos campos
        $stmt = $conn->prepare("
            INSERT INTO MUTUAL_EVALUACION (ID_USUARIO, PUNTOS_DESTACAR, PUNTOS_MEJORAR, ACCIDENTES)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->bind_param("issi", $id_usuario, $puntos_destacar, $puntos_mejorar, $accidentes);
        $stmt->execute();
        $id_evaluacion = $conn->insert_id;
        $stmt->close();

        $nota_total_general = 0;

        // Recorrer partes
        foreach ($dominios_por_parte as $id_parte => $dominios) {
            $nota_parte = isset($notas_parte[$id_parte]) ? floatval($notas_parte[$id_parte]) : 0;
            $observacion = $observaciones[$id_parte] ?? '';

            $nota_total_general += $nota_parte;

            // Insertar detalle de parte
            $stmt = $conn->prepare("
                INSERT INTO MUTUAL_DETALLE_PARTE (ID_EVALUACION, ID_MUTUAL_PARTE, NOTA_PARTE, OBSERVACIONES)
                VALUES (?, ?, ?, ?)
            ");
            $stmt->bind_param("iids", $id_evaluacion, $id_parte, $nota_parte, $observacion);
            $stmt->execute();
            $id_detalle_parte = $stmt->insert_id;
            $stmt->close();

            // Insertar dominios
            $stmt = $conn->prepare("
                INSERT INTO MUTUAL_DETALLE_DOMINIO (ID_MUTUAL_DETALLE_PARTE, ID_MUTUAL_DOMINIO)
                VALUES (?, ?)
            ");
            foreach ($dominios as $id_dominio => $valor) {
                $stmt->bind_param("ii", $id_detalle_parte, $id_dominio);
                $stmt->execute();
            }
            $stmt->close();
        }

        // Actualizar nota final
        $stmt = $conn->prepare("UPDATE MUTUAL_EVALUACION SET NOTA_FINAL = ? WHERE ID_EVALUACION = ?");
        $stmt->bind_param("di", $nota_total_general, $id_evaluacion);
        $stmt->execute();
        $stmt->close();

        $conn->commit();
        echo "<p style='color: green;'>✔ Evaluación registrada correctamente con nota final: $nota_total_general</p>";

    } catch (Exception $e) {
        $conn->rollback();
        echo "<p style='color: red;'>❌ Error al guardar evaluación: " . $e->getMessage() . "</p>";
    }

} else {
    echo "<p style='color: red;'>❌ Método no permitido.</p>";
}
?>